# Plugin Flluir - Adobe Premiere Pro (CEP)

Plugin CEP (Common Extensibility Platform) para sincronizar comentários da plataforma Flluir com marcadores no Adobe Premiere Pro.

## 📋 Requisitos

- **Adobe Premiere Pro** 14.0 ou superior
- **Windows** ou **macOS**
- Token de autenticação gerado na plataforma Flluir

## 🚀 Instalação (Recomendado)

Se você recebeu um arquivo ZIP (`Plugin-Flluir-v1.0.4.zip`):

1. **Extraia o ZIP** em qualquer local temporário
2. **Siga as instruções** no arquivo `INSTALACAO.txt` dentro da pasta extraída.

---

## ⚙️ Configuração

### 1. Obter Token de Autenticação

1. Acesse a plataforma Flluir
2. Vá em **Configurações** → **Integrações** → **Premiere Pro**
3. Clique em **Gerar Token**
4. Copie o token gerado (aparece apenas uma vez)
Obs.: Caso perca o token gerado, peça para revogar o token e gere um novo.

### 2. Configurar o Plugin

1. No painel do plugin, insira a **URL da API**:`https://app.flluir.com` ou `https://app.flluir.com.br` (sem aspas'')
2. Cole o **Token de Autenticação** copiado
3. Clique em **Salvar**
4. Clique em **Testar Conexão** para verificar

## 📖 Uso

### Carregamento Automático

Após configurar e testar a conexão, o plugin automaticamente:
- Carrega todos os projetos com arquivos de vídeo
- Seleciona o primeiro projeto
- Carrega os arquivos de vídeo do projeto
- Seleciona o primeiro arquivo
- Carrega os comentários do arquivo
- Sincroniza com o Premiere 
- Apapaga as marcações (se achar necessário)

### Navegação Manual

- **Atualizar Projetos**: Recarrega a lista de projetos
- **Atualizar Arquivos**: Recarrega os arquivos do projeto selecionado
- **Abrir Comentários**: Carrega os comentários do arquivo selecionado
- **Recarregar Comentários**: Recarrega a lista de comentários


### Sincronizar com Premiere

1. Após carregar os comentários, clique em **Sincronizar com Premiere**
2. Os comentários serão criados como marcadores na sequência ativa
3. Cada marcador terá:
   - **Nome**: Autor + ID do comentário (ex: "João Silva [#abc123]")
   - **Comentário**: Texto completo do comentário (incluindo respostas)
   - **Timestamp**: Exatamente no tempo marcado pelo usuário no Flluir

### Desfazer marcações

1. Após carregar os comentários e sincronizar os marcadores na sequência ativa, ao clicar em **Desfazer marcações** todos os macadores serão excluidos.


## 🔧 Estrutura do Plugin

```
Plugin Flluir/
├── CSXS/
│   └── manifest.xml          # Manifest do CEP
├── jsx/
│   └── FlluirSync.jsx        # Script ExtendScript para Premiere
├── index.html                # Interface HTML
├── styles.css                # Estilos CSS
├── main.js                   # Lógica JavaScript
├── CSInterface.js            # (Baixar separadamente)
└── README.md                 # Este arquivo
```

## 🐛 Troubleshooting

### Erro 51 no Windows - "Plug Plug extension failed to load with error: 51"

**Este é o erro mais comum no Windows!**

**Solução:**
1. Feche COMPLETAMENTE o Premiere Pro
2. Abra a pasta **REG**
3. Execute o script `habilitar-cep-windows.reg`
4. Abra o Premiere Pro novamente
5. O plugin deve funcionar normalmente

Para mais detalhes, consulte a seção "Erro 51 no Windows" no arquivo `TROUBLESHOOTING.md`.

### Plugin não aparece no menu

**Windows:**
- Verifique se o arquivo `debugmode` foi criado corretamente
- Verifique se o Registro do Windows está configurado (aquivo `habilitar-cep-windows.reg` da pasta **REG**)
- Verifique se a pasta `Plugin Flluir` está no local correto
- Reinicie o Premiere Pro completamente
- Verifique se o Premiere Pro é versão 14.0 ou superior

**macOS:**
- Verifique se o arquivo `debugmode` foi criado corretamente
- Verifique se a pasta `Plugin Flluir` está no local correto
- Reinicie o Premiere Pro completamente
- Verifique se o Premiere Pro é versão 14.0 ou superior

### Erro de conexão com API

- Verifique se a URL da API está correta
- Verifique se o token está válido (gere um novo se necessário)
- Verifique se o servidor está rodando
- Use o console de debug (botão "Debug" no canto inferior direito)

### Comentários não aparecem

- Verifique se há comentários no arquivo na plataforma web
- Verifique se o arquivo está associado a um projeto
- Verifique se os comentários têm timestamp (timeline_ms)
- Verifique os logs no console de debug

### Marcadores não são criados

- Verifique se há uma sequência ativa no Premiere Pro
- Verifique se a sequência está aberta na timeline
- Verifique os logs no console de debug
- Tente criar um marcador manualmente no Premiere para verificar se a funcionalidade está habilitada

## 📝 Notas

- O plugin salva automaticamente as configurações no `localStorage`
- Os marcadores criados no Premiere incluem o ID do Flluir no formato `[#ID]`
- O plugin requer uma sequência ativa para sincronizar marcadores
- Apenas projetos com arquivos de vídeo são exibidos
- Apenas arquivos de vídeo são exibidos na lista

## 🔐 Segurança

- O token de autenticação é armazenado localmente no `localStorage`
- As comunicações com a API usam HTTPS em produção
- Nunca compartilhe seu token de autenticação
- O token pode ser revogado a qualquer momento nas configurações

## 📞 Suporte

Para problemas ou dúvidas, consulte a documentação da plataforma ou entre em contato com o suporte.
